/*------------------------------------------------------------------------------*
 * File Name: Themes.h					 										*
 * Purpose: Declare functions that are related to Themes						*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED			*
 *  Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME					*
 *  Frank 1/22/05 CENTRALIZE_MARCO_OF_FOLDER_INFO								*
 *	RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT							*
 *	DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE										*
 *	DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES						*
 *	DSC 5/23/05 MOVE_GET_CLASS_SETTINGS_TO_VC									*
 *	DSC 6/27/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME						*
 *	YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT										*
 *	DSC 8/5/05 MORE_NEW_COMPOSITE_NAME_FORMAT									*
 *	ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS					*
 *  Joe 8/10/06 THEME_SCOPEINDEX_TO_SCOPENAME									*
 *  Joe 8/10/06 THEME_ANALYSIS_FILENAME_TO_OPTIONS                              *
 *  Joe 8/11/06 THEME_SCOPENAME_TO_SCOPEINDEX 									*	
 *  SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET						*
 *	Jasmine 10/11/06 GET_CELL_AND_LABEL_HEIGHT									*
 *	ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
 *	Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG								*
 *	Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT								*
 *	ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC								*
 *	Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS								*
 *	Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK								*
 *	Jasmine 03/27/07 MOVE_TO_TEXTFORMAT											*
 *	Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE				*
 *	Folger 04/26/07 WKS_GET_CELL_HEIGHTS										*
 *	Folger 05/23/07 XF_IS_THEME_APPLIED											*
 *	Folger 06/19/07 ADD_INIT_THEME_LIST											*
 *	Sim 06-30-2007 XF_IS_THEME_APPLIED											*
 *	Sim 06-30-2007 PUT_OUT_GLOBAL_FUNC											*
 *	Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS				*
 *	Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME								*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME								*
 *	Folger 11/08/07 FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION				*
 *	Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM								*
 *	Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO									*
 *	Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM					*
 *	Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST				*
 *	Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
 *	Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM						*
 *	Folger 04/15/08 QA80-11192 LOAD_XF_WIZARD_DEFAULT_THEME_NEED_VERSION_CHECKING
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Folger 05/07/08 SHOULD_NOT_GENERATE_OPERATION_THEME_WHEN_RUN_FROM_PA		*
 *	Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
 *	Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
 *	Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER					*
 *	Sim 09-05-2008 CLEAN_DEFAULT_THEME											*
 *	Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING								*
 *	Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5							*
 *	Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING		*
 *	Sim 12-12-2008 IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE			*
 *	Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
 *	Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER
 *	Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS			*
 *	Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
 *	Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
 *	Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI					*
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *	Folger 04/22/10 QA81-15348 OP_CHANGE_FROM_PA								*
 *	Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT						*
 *------------------------------------------------------------------------------*/

#ifndef _THEMES_H
#define _THEMES_H

/*
///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
#define		STR_THEME_NAME_NULL 	"Untitled"
#define 	STR_CLASS_OPTION_NULL	"Unknown"
enum {
	THTYPESCOPE_UNDEF = -1,
   THTYPESCOPE_ANALYSIS_CLASS, // for class specific
   THTYPESCOPE_ANALYSIS_CATEGORY, //for a particular category
   THTYPESCOPE_ANALYSES_COMMON //for all analysis       
};

///End ADD_THEME_SAVE_AS_BOX


#define THEME_FILE_NODE_NAME 	"File"
#define THEME_TYPE_ATTRIBUTE 	"Type"
*/

///DSC 2/17/05 GET_ORIGIN_PATH
/*
enum {
	THTYPE_SYSTEM,
	THTYPE_USER,
	THTYPE_GROUP,///DSC 2/16/05
};
*/
///end GET_ORIGIN_PATH

/// Hong QA80-11640 v8.0982b SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING
#define STR_SAVE_THEME_CAPTION		_L("Theme Saving")
#define STR_SAVE_THEME_ASK_REPLACE	_L("The named theme file already exists, do you want to replace it?")
#define STR_SAVE_THEME_BAD_FILENAME _L("The specified theme name is not a valid file name.")
/// end SUPPORT_DRAG_AND_DROP_THEME_FOR_EASY_SHARING

//------ Folger 04/15/08 QA80-11192 LOAD_XF_WIZARD_DEFAULT_THEME_NEED_VERSION_CHECKING
#define STR_WIZARD_VERSION		"WizardVersion"
//------

//------ Folger 05/07/08 SHOULD_NOT_GENERATE_OPERATION_THEME_WHEN_RUN_FROM_PA
#define	STR_NO_OPERATION_THEME_ATTRIB		"NoOperationTheme"
//------
#define STR_DEFAULT_SETTINGS_FILENAME GetAppPath() + "Defaults.XML" ///Sophy 10/28/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE moved from theme_utils.c as to use it in DynaDlg.h

//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
#define		NEW_DEFAULT_THEME_MECHANISM
//---------- CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
//#ifdef		NEW_DEFAULT_THEME_MECHANISM
//#define		STR_NEW_DEFAULT_THEME			"<Default>"
//#define		STR_NEW_DEFAULT_THEME_L			_L(STR_NEW_DEFAULT_THEME)
//#define		STR_NEW_DEFAULT_THEME_L			STR_DEFAULT
//------
//#endif
//----------
#define		THEME_FILE_FACTORY_DEFAULT		"Factory Default"		//for file name valid testing

#define		THEME_FILE_DELETED_FOLDER		"Deleted\\"				//------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER

enum {
	THEMEAPPLY_SELECTION = 0,
	THEMEAPPLY_LAYER,
	THEMEAPPLY_PAGE,
	THEMEAPPLY_FOLDER,
	THEMEAPPLY_PROJECT,
	THEMEAPPLY_GRAPH_IN_WKS	///Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS
};

#define STR_XF_NAME_ATTRIB "XF_NAME"	///Joseph Sim 03-26-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS
///---Joseph Sim 03-30-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS
#define STR_XFBAR_MULITIMODE_THEME_TREE	"ThemeTree"	

#define STR_XFBAR_MULITIMODE_RUNTIME_INFO_TREE	"RunTimeInfo"	
///End TEMPORARY_FUNCTION_FOR_THEME_UTILS
#define STR_XFBAR_MULITIMODE_EXEC_VALUE_TREE	"ExecValueInfo" ///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO

#define STR_XF_WIZ_THEME_SHARED "Shared" ///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING


#define STR_THEME_COMMENT_ATTRIB	STR_COMMENT_ATTRIB

#define STR_LABEL_THEME_FILTER_SETTING	_L("Theme Setting") ///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS

// moved to okutil: string 	theme_get_system_theme_file_name(int nThemeType = THTYPE_GRAPH);
// #define theme_get_system_theme_file_name	okutil_theme_get_system_theme_file_name
// string 	theme_get_theme_file_name(string strThemeName, bool bIsEXEpath = false);
//string 	theme_get_theme_file_name(string strThemeName, int nPathType = ORIGIN_PATH_USER);///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
// moved to okutil: string 	theme_get_theme_file_name(string strThemeName, int thtype = THTYPE_GRAPH, int nPathType = ORIGIN_PATH_USER);///Iris 2/22/05 QA70-7416
// #define theme_get_theme_file_name okutil_theme_get_theme_file_name
//bool 	theme_rename(string strThemeName, string strOldName, bool bIsEXEpath);
//bool 	theme_rename(string strThemeName, string strOldName, int nPathType);///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
// bool 	theme_rename(string strThemeName, string strOldName, int nPathType, int nThemeType);///DSC 2/23/05
// bool 	theme_system_getset(string strThemeName, bool bSet = false, bool bSetAs = false, bool bIsEXEPath=false); // if not set, then test
// bool 	theme_system_getset(string strThemeName, bool bSet, bool bSetAs, int nPathType);///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
bool theme_system_getset(string strThemeName, bool bSet, bool bSetAs, int nPathType, int nThemeType);
bool 	theme_is_in_clipboard();
// string 	theme_get_path(bool bEXEpath = false);
//string  theme_get_path(int nPathType = ORIGIN_PATH_USER);
// moved to okutil: string theme_get_path(int nPathType = ORIGIN_PATH_USER, int thtype = THTYPE_GRAPH, bool bCheckUnique = false);  ///Iris 2/22/05 QA70-7416
// #define theme_get_path 	okutil_theme_get_path
//uint 	theme_find_all_theme_files(TreeNode& trNode);
//uint 	theme_find_all_theme_files(TreeNode& trNode, int nPathType = ORIGIN_PATH_UNDEF);
// moved to okutil: string 	theme_get_file_extension(int nThemeType);
// #define theme_get_file_extension	okutil_theme_get_file_extension
int 	theme_get_type_from_page_type(int nPageType);
uint 	theme_find_all_theme_files(TreeNode& trNode, int nPathType = ORIGIN_PATH_UNDEF, int nThemeType = THTYPE_GRAPH);
// TreeNode theme_add_one_theme_file(TreeNode& trNode, const string& strFilename, bool bUser = true);
TreeNode theme_add_one_theme_file(TreeNode& trNode, const string& strFilename, int nPathType);///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
// bool 	theme_get_next_file_name(string& strFilename, bool bCheckCreatePath=true);
// bool theme_get_next_file_name(string& strFilename, bool bCheckCreatePath=true, int nThemeType = THTYPE_GRAPH);///DSC 2/22/05
int		theme_count_properties(LPCSTR lpcszThemeFilename, int* lpnSections = NULL);
//string	theme_get_system_theme();
string	theme_get_system_theme(string* pstrPathKeyword = NULL);// for 7.5 only. use for getting old 7.5 sys theme setting
// moved to okutil: string	theme_get_system_theme(int nThemeType);
// #define theme_get_system_theme	okutil_theme_get_system_theme
// #define theme_get_system_theme_ini_keyname 		okutil_theme_get_system_theme_ini_keyname
 

/**$
*/
bool apply_system_theme(Grid& grid, int nThemeType);

bool	theme_apply(int nTo, const string& strFile);

enum {
	SAVETHEME_ALL = 0,
	SAVETHEME_ALL_STYLES,
	SAVETHEME_COLORS,
	SAVETHEME_FONTS,
	SAVETHEME_DIMS,
	SAVETHEME_SCALES,
	SAVETHEME_TEXT,
	SAVETHEME_BACKGROUND,
	SAVETHEME_PLOTS,

	SAVETHEME_TOTAL,
};

//--- CPY 2/21/05 THEME_SAVE_FORMAT_WKS
//bool	theme_copy_format_to_file(LPCSTR lpcszFilename, DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL);
// return EXIST_WKS, EXIST_GRAPH, or EXIST_NONE
int	theme_copy_format_to_file(LPCSTR lpcszFilename, bool bIgnoreSel = false, DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL);
//---
bool	theme_combine_filter_bits(int nType, DWORD& dwProperties, DWORD& dwObjects);

//dwNodeDelBits
enum {
	TH_DEL_GRID_COL_HEADING = 0x01,
	TH_DEL_GRID_ROW_HEADING = 0x02,
	TH_DEL_GRID_RANGES		= 0x04,
};
/**$
*/
bool theme_get_from_wks_grid(Worksheet& wks, Tree& trTheme, DWORD dwPropFilter= FPB_ALL, DWORD dwObjFilter = FOB_ALL, DWORD dwNodeDelBits = 0);
/**$
*/
bool grid_edit_user_comments(Grid& gg);
/**$
*/
bool grid_copy_to_clipboard(Grid& gg);
/**&
*/
bool grid_has_footnote(Grid& gg);

/// ML 3/7/2007 QA70-9451 SET_LINKS_TRANSPOSED_ETC
///// ML 1/22/2007 QA70-9189 MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
//bool grid_make_copy_as_flat_sheet(Grid& gg);
///// end MAKING_A_FLAT_SHEET_WITH_LINKS_ONLY_AND_IN_DATA_AS_WELL_AS_LABELS_AREA_OUT_OF_A_WHOLE_SOURCE_TABLE
bool grid_make_copy_as_flat_sheet(Grid& gg, BOOL bTransposed = FALSE);
/// end SET_LINKS_TRANSPOSED_ETC


/**$
	hide column and row headings and labels
	NULL to show all
	0 = heading, 1,2,3 depends on labels shown
*/
bool wks_set_hide_headings(Worksheet& wks, vector<int>& vnCols, vector<int>& vnRows = NULL);
/**$
*/
bool wks_get_labels_show_theme(const Worksheet& wks, Tree& tr);
//----

///Jasmine 04/17/07 QA80-9619 APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
//in percentage, default column width is also 100
#define DEFAULT_WKS_ROW_HEIGHT	100	
///End APPEND_VECTOR_AND_FILL_DEFAULT_VALUE
/**$
*/
bool wks_set_cell_heights(Worksheet& wks, int n1, int n2, int nSize, bool bCol);

//bool wks_set_col_label_heights(Worksheet& wks, int nLabelType, int nSize);
bool wks_set_col_label_heights(Worksheet& wks, int nLabelType, int nSize, bool bUndo = true); /// Hong 11/01/07 v8.0738 SPARKLINES_SHOULD_NOT_HAVE_THEME_UNDOABLE
///Jasmine 10/11/06 GET_CELL_AND_LABEL_HEIGHT
///Folger 04/26/07 WKS_GET_CELL_HEIGHTS
//int wks_get_cell_heights(Worksheet& wks, int n1, int n2, bool bCol);
int wks_get_cell_heights(Worksheet& wks, int n1, int n2, bool bCol, bool bFirst = true);
///End WKS_GET_CELL_HEIGHTS

int wks_get_col_label_heights(Worksheet& wks, int nLabelType);
///End GET_CELL_AND_LABEL_HEIGHT

#ifdef _CONTROL_H
/**
	Parameters:
		theDlg = the current dilaog object
		nListViewCheckID = id of the check box "List View"
		nTreeID = id of the TreeEditor control
	Example:
		static BOOL OnListViewCheck(Control oCntrl)
		{
			theme_update_tree_list_view(MyDlg, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE);
			return TRUE;
		}
*/
///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
//void theme_update_tree_list_view(Dialog& theDlg, int nListViewCheckID, int nTreeID, bool bShowEmpty=false, bool bShowCollection=false);
DWORD theme_update_tree_list_view(bool btnListViewCheck, bool bShowCollection, bool bShowEmpty = false);
///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	

/**
	Parameters:
		theDlg = the current dilaog object
		lpcszFilename = a theme file name
		nSizeID = id of the static box to display size of theme
*/
//void theme_update_size(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID = 0);///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	

/**
	Provides Filtering support for the Theme Tree in a dialog
	Parameters:
		theDlg = the current dilaog object
		nListViewCheckID = id of the check box "List View"
		nTreeID = id of the TreeEditor control that holds the theme tree
	Returns:
		TRUE if the Theme is modified by the Filer dialog, return FALSE otherwise
	Example:
		static BOOL OnThemeFilter(Control oCntrl)
		{
			theme_filter_dialog(MyDlg, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE);
			return TRUE;
		}	
*/
///Frank 9/13/05 v8.0305 REMOVE_DIALOGEX_FROM_THEME_ULTILS	
//bool theme_filter_dialog(Dialog& theDlg, int nIDListView, int nIDTree);
bool theme_filter_dialog(HWND hWnd, string &strTempThemeFile);
///End REMOVE_DIALOGEX_FROM_THEME_ULTILS	

class TempThemeFile
{
	~TempThemeFile()
	{
		if(m_strTempFilename.IsFile())
			DeleteFile(m_strTempFilename);
		
		m_strTempFilename.Empty();
	}
public:
	bool Init(LPCSTR lpcszThemeFilename)
	{
		string strFilename = lpcszThemeFilename;
		if(!strFilename.IsFile())
			return false;
		if(!GetTempFileName(m_strTempFilename))
			return false;		
		
		FileCopy(strFilename, m_strTempFilename);
		return true;
	}
	string GetFileName() {return m_strTempFilename;}
private:
	string	m_strTempFilename; 
};

/**
	Parameters:
		dlg = the current dilaog object
		nButtonIDs = zero terminated array of button ids for all the buttons that should be placed at the top right corner of the dialog
		nMainItemID = id of the control that is to be sized on the left of the buttons specified by nButtonIDs
	Returns:
		The gap (pixels) between controls. This can be used by the calling function to further poisition other controls
	Example:
		static BOOL OnDlgResize(int nType, int cx, int cy)
		{
			uint nBtnIds[] = {
				IDOK,
				IDCANCEL,
				IDC_STYLSHT_FILTER,
				IDC_STYLSHT_LIST_VIEW, 0};
			
			dlg_resize_buttons_relative_to_main_item(MyDlg, nBtnIds, IDC_STYLSHT_TREE, cx, cy);
				
			return TRUE;
		}
int dlg_resize_buttons_relative_to_main_item(Dialog& dlg, uint nButtonIDs[], uint nMainItemID, int cx, int cy);
*/

#endif //_CONTROL_H
///Frank 1/22/05 CENTRALIZE_MARCO_OF_FOLDER_INFO
///Danice QA70-6222 RIGHT_CLICK_ACCESS
//#define TREE_PROPERTY_SAVE_PATH				GetAppPath(1)+"Themes\\"
//#define TREE_PROPERTY_SAVE_PATH_USER		GetAppPath(false)+"Themes\\" //CPY 9/21/04
//#define TREE_PROPERTY_SAVE_PATH_ALL_USER		GetAppPath(1)+"All user\\Themes\\" ///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	

///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
// #define TREE_PROPERTY_SAVE_PATH				get_origin_path(SYS_FOLDER, "Themes")	//GetAppPath(1)+"Themes\\"
// #define TREE_PROPERTY_SAVE_PATH_USER		get_origin_path(USER_FOLDER, "Themes")	//GetAppPath(false)+"Themes\\" //CPY 9/21/04
// #define TREE_PROPERTY_SAVE_PATH_ALL_USER	get_origin_path(ALL_USER_FOLDER, "Themes")	//	GetAppPath(1)+"All user\\Themes\\" ///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE
//	#define TREE_PROPERTY_SAVE_PATH				get_origin_path(ORIGIN_PATH_SYSTEM, "Themes")	//GetAppPath(1)+"Themes\\"
//	#define TREE_PROPERTY_SAVE_PATH_USER		get_origin_path(ORIGIN_PATH_USER, "Themes")	//GetAppPath(false)+"Themes\\" //CPY 9/21/04
//	#define TREE_PROPERTY_SAVE_PATH_ALL_USER	get_origin_path(ORIGIN_PATH_GROUP, "Themes")	//	GetAppPath(1)+"All user\\Themes\\" ///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE
///end USE_ENUM_ORIGIN_PATH_TYPE

/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC moved to outils.h	
// #define STR_THEME_ORGANIZER_FILE_NAME		"themeOrganizer.xml"///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
// #define TREE_THEME_BRANCH_FOLDER			"BranchThemes\\"///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
/// end MOVE_GET_CLASS_SETTINGS_TO_VC

///DSC 2/22/05 use (string)THTYPESCOPE_ANALYSIS_CLASS, (string)THTYPESCOPE_ANALYSES_COMMON
// #define THEME_FILENAME_COMMON_PREFIX		"0"
// #define THEME_FILENAME_CLASS_PREFIX			"1"
///end

///End CENTRALIZE_MARCO_OF_FOLDER_INFO
///Forest 09/13/04 QA70-6682 GETN_THEME_SAVEAS_NEW_DIALOG

/*
#define THEME_FILENAME_LAST_USED		_L("Last Used")
#define THEME_FILENAME_FACTORY_DEFAULT	_L("Factory Default")
*/

///DSC 2/2/05 v8/0189 CENTRALIZE_PATH_PREFIX_CODES
// ///Frank 1/22/05 CENTRALIZE_MARCO_OF_FOLDER_INFO
// //#define THEME_DISPLAY_NAME_SYSTEM_PREFIX _L("System")
// //#define THEME_DISPLAY_NAME_USER_PREFIX _L("User")		///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
// //#define THEME_DISPLAY_NAME_ALL_USER_PREFIX _L("All User")  ///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
// #define THEME_DISPLAY_NAME_SYSTEM_PREFIX 	get_origin_folder_type_info(SYS_FOLDER)	 	//
// #define THEME_DISPLAY_NAME_USER_PREFIX 		get_origin_folder_type_info(USER_FOLDER)		//_L("User")		///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
// #define THEME_DISPLAY_NAME_ALL_USER_PREFIX	get_origin_folder_type_info(ALL_USER_FOLDER)	//_L("All User")  ///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
// ///End CENTRALIZE_MARCO_OF_FOLDER_INFO
// #define THEME_DISPLAY_NAME_PREFIX_SEP	": "

//-- Also use STR_PREFIX_SYSTEM_SEP, STR_PREFIX_USER_SEP, STR_PREFIX_ALL_USER_SEP with separator STR_PREFIX_NAME_SEP included if you need
///DSC 8/5/05 MORE_NEW_COMPOSITE_NAME_FORMAT remove these, they should not be used
// #define THEME_DISPLAY_NAME_SYSTEM_PREFIX 	STR_PREFIX_SYSTEM
// #define THEME_DISPLAY_NAME_USER_PREFIX 		STR_PREFIX_USER
// #define THEME_DISPLAY_NAME_ALL_USER_PREFIX	STR_PREFIX_ALL_USER	
// #define THEME_DISPLAY_NAME_PREFIX_SEP		STR_PREFIX_NAME_SEP
///end MORE_NEW_COMPOSITE_NAME_FORMAT
///end CENTRALIZE_PATH_PREFIX_CODES



#define THEME_ATTRIB_SYSTEM_PATH_CHAR	'*'
#define THEME_ATTRIB_GROUP_PATH_CHAR	'?'

/*
#define THEME_FILENAME_DEFAULT			"Default"
#define THEME_FILENAME_COPY				"Copy"
#define	THEME_FILENAME_NO_CLASS			"Common"
*/
///End GETN_THEME_SAVEAS_NEW_DIALOG

/**#?
*/
/// Hong 08/06/07 v8.0675 THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS
//bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile = NULL, bool bCheckCreatePath = true);
///------ Folger 06/13/10 ORG-120 DATA_DISPLAY_DIALOG_IMPROVEMENT
//bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile = NULL, bool bCheckCreatePath = true, TreeNode& trSrc = NULL);
bool theme_save_settings(const TreeNode& tr, LPCSTR lpcszFile = NULL, bool bCheckCreatePath = true, TreeNode& trSrc = NULL, TreeNode& trThemeOut = NULL);
///------ End DATA_DISPLAY_DIALOG_IMPROVEMENT
/// end THEME_SUPPORT_NOT_SAVE_UNCHANGE_SETTINGS

/**#?
	return path type and remove leading '*' or '?' if present
*/
///Iris 2/23/05 UPDATE_LOAD_THEME_FILE_LIST
//bool theme_load_default_settings(TreeNode& tr, bool* pbSystemPath = NULL);
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_load_default_settings(TreeNode& tr, int* pnPath=NULL);
bool theme_load_default_settings(TreeNode& tr, int* pnPath=NULL, TreeNode& trTheme = NULL);
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
///End SETTINGS_THEME_FILE_SAVE_LOAD

/**#?
*/
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_load_settings(TreeNode& tr, LPCSTR lpcszFile, bool bLoadFactDefault=true);
bool theme_load_settings(TreeNode& tr, LPCSTR lpcszFile, bool bLoadFactDefault=true, TreeNode& trTheme = NULL);
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION

/**#?
	get theme-file-name with and without path
	search both System and User path and set strFullpathFilename to the found file, or use User path if not found
	Parameters:
		strClassNameWithOption = theme file are categorized by Origin C class that makes use of a theme
		strFullpathFilename = [out] the full path file name for the theme file
		lpcszTheme = name of the theme that we need to find the theme file name from
	Return:
		if lpcszTheme = THEME_FILENAME_FACTORY_DEFAULT, then return empty str
		if lpcszTheme = THEME_FILENAME_LAST_USED, then set strFullpathFilename to empty as caller will know where to find it
		if lpcszTheme = NULL or "", then assume THEME_FILENAME_LAST_USED
		when str is returned, it is always the proper construct with with the form of ClassName_option-ThemeName.ois
*/
///Frank 01/21/05 v8.0185b THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE	
//string theme_get_settings_file(const string& strClassNameWithOption, string& strFullpathFilename, LPCSTR lpcszTheme = NULL); 
//string theme_get_settings_file(const string& strClassNameWithOption, string& strFullpathFilename, LPCSTR lpcszTheme = NULL , bool bSaveBranchTheme = false); 
//CPY 2/24/05, modify function and if lpcszThemeDisplayName = NULL, then return last-used theme filename
// this function returns full path file name
///DSC 3/1/05 v8.0200 CENTRALIZE_PATH_CATEGORY_NAME_CODES
// string theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassNameWithOption = NULL,  string* pstrThemeName = NULL);
// string theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassNameWithOption = NULL, int nThemeType = THTYPE_ANALYSIS, string* pstrThemeName = NULL, int* pnScope=NULL, LPCSTR lpcszCategory=NULL);
///end CENTRALIZE_PATH_CATEGORY_NAME_CODES

//int theme_add_settings(vector<string> &vsFilenames, vector<string> &vsDisplayNames, LPCSTR lpcszFilePath,  LPCSTR lpcstrPrefix,LPCSTR lpcszClassName, LPCSTR lpcszAddPrefix);

///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
// int theme_find_class_categories(LPCSTR lpcstrClassName, vector<string> &vsCategoryName);
// int okutil_theme_find_class_categories(LPCSTR lpcstrClassName, StringArray* psaCategoryName);
///end MOVE_GET_CLASS_SETTINGS_TO_VC

//int		theme_get_class_settings(LPCSTR lpcszClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames); ///duplicate 
///End THEME_SUPPORT_CATEGORY_AND_BRANCH_THEME_CHANGE
///Iris 02/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX	
/////Frank 01/22/05 v8.0185b THEME_CENTERZIER_CODE
//enum {COMMON_THEME_FILE, CLASS_THEME_FILE, CATEGORY_THEME_FILE};
/////End THEME_CENTERZIER_CODE
///End ADD_THEME_SAVE_AS_BOX

//string theme_file_to_display_name(const string& strThemeFile, string* pstrCategory = NULL, int* pnPathType = NULL);

///DSC 6/27/05	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME
// int theme_separate_class_option(LPCSTR lpcszClassOption, string& strClassName);
///end	CONSTRUCT_THEME_FILE_FROM_COMPOSITE_NAME

///Forest 09/15/04 QA70-6682 SETTINGS_THEME_FILE_SAVE_LOAD, implemented in Operation.c
/**$
	Returns the number of theme files of lpcszClassname.
	vsFilenames include extension .ois, but not include path; vsDisplayNames not include .ois .
*/
//int		theme_get_class_settings(LPCSTR lpcszClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames,  bool bisGetBranchTheme = false);
//int		theme_get_class_settings(LPCSTR lpcszClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames, int thtype =THTYPE_ANALYSIS);
//int		theme_get_class_settings(LPCSTR lpcszClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames, int thtype = THTYPE_ANALYSIS, bool bIncludeFactoryAndUsed = false);  ///Iris 03/07/05 QA70-7345 ADD_FB_FILTER_THEME
///DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
// // int		theme_get_class_settings(LPCSTR lpcszClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames, int thtype = THTYPE_ANALYSIS, bool bIncludeFactory = false, bool bIncludeLastUsed = false); 
// int		okutil_theme_get_class_settings(LPCSTR lpcszClassname, StringArray* psaFilenames, StringArray* psaDisplayNames, int thtype = THTYPE_ANALYSIS, BOOL bIncludeFactory = false, BOOL bIncludeLastUsed = false); 
///end MOVE_GET_CLASS_SETTINGS_TO_VC

///Forest 10/09/04 QA70-6682   CENTRALIZE_CODE_ON_BRANCH_THEME
bool	theme_load_factory_default(LPCSTR ClassNameWithOption, TreeNode& tr);

//get ClassOption from STR_THEME_FILE_ATTRIB of tr, if no attribute or attribute is factory default, return false
bool	theme_get_class_option(const TreeNode& tr, string& strClassOption);
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool	theme_update_on_new_sel(TreeNode& tr, LPCSTR lpcszSelThemeName);
bool	theme_update_on_new_sel(TreeNode& tr, LPCSTR lpcszSelThemeName, TreeNode& trTheme = NULL);
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
bool	theme_get_class_option_and_current_theme(const TreeNode& tr, string& strClassOption, string& strThemeName);
//int 	theme_add_class_settings(const string& strClassname, vector<string>& vsFilenames, vector<string>& vsDisplayNames, const string& strPath, LPCSTR lpcszDisplayPrefix = NULL, bool isGetBranchThemes = false);

#define	STR_DEFAULT_THEME_NAME				"DefaultThemeName"	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//string	theme_ask_save_as_filename(TreeNode& tr, HWND hWndParent);
string	theme_ask_save_as_filename(TreeNode& tr, HWND hWndParent, TreeNode& trThemeFilter = NULL);
///---END QA80-11371 THEME_SAVING_OPTIONS
//string	theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemeFilename, HWND hWndParent, string *pstrDescription = NULL, bool bSaveBranchTheme = false );
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//string  theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemeName, HWND hWndParent, string *pstrDescription = NULL, int nthtype = THTYPE_ANALYSIS);
string  theme_ask_save_as_filename(LPCSTR lpcszClassNameWithOption, string& strThemeName, HWND hWndParent, string *pstrDescription = NULL, int nthtype = THTYPE_ANALYSIS, TreeNode& trThemeFilter = NULL
								   ///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
								   , LPCSTR lpcszCustomMakeTree = NULL
								   , LPCSTR lpcszCustomName = NULL
								   ///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
								   );
///---END QA80-11371 THEME_SAVING_OPTIONS
int theme_get_list(const TreeNode& tr, vector<string>& vsList, bool bRetZeroIfNotInThemeList = true );

///------ Folger 09/23/09 Q8A0-14339-P6 NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG
int		theme_get_list_filter_last_used(const TreeNode& tr, vector<string>& vsList, bool bRetZeroIfNotInThemeList = true);
///------ End NOT_ALLOW_REMOVE_LAST_USED_IN_THEME_DELETE_DIALOG

///Frank 1/25/05 THEME_SAVE_AS_DIALOG
bool theme_set_commment_to_gui_tree(TreeNode &tr, LPCSTR lpcszComment);
string theme_get_commment_to_gui_tree(const TreeNode &tr);
int theme_get_display_name(const TreeNode& tr , string& strThemeName);
///End THEME_SAVE_AS_DIALOG

///End CENTRALIZE_CODE_ON_BRANCH_THEME

//--- CPY 10/17/05 ANALYSIS_THEME_USE_CENTRLIZED_FUNC
//bool theme_load_themeorganizer(TreeNode &trThemeorganizer);
bool theme_load(Tree& trTheme, LPCSTR lpcszThemeFileWithExt, LPCSTR lpcszSubPath = NULL);


/// RVD 1/19/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT
bool theme_copy_to_clipboard(const TreeNode& tr);
bool theme_get_from_clipboard(Tree& tr);//CPY
/// end WKS_THEME_SUPPORT

/*
	Theme save as GetN Box.
	Parameters:
		strPathName = [output]the pathname for saving, all info are encoded in filename
		thtype = [input] the theme type, THTYPE_GRAPH etc
		strThemeName = [modify] the theme name that should appear initially in the "Theme Name" field and also update by user
		strDescription = [output] description
		lpczClassOption = [input] Class name and option, like DescStats_0. Get it from STR_ATTRIB
		thScopeType = [modify] the initial selection for scope, like THTYPESCOPE_ANALYSIS_CLASS etc. (or NULL if no scope option)
		strCategory = [modify] if scope is category, then user might pick or create a category
		pnAllTables = [modify] (used only for THTYPE_REPORT_TABLE)
                   // "This Table" and "All tables" choices, the analysis report table, should theme table ID be added to theme name 
                   // on input, table ID, on output, set to 0 if All Tables
	Example1:
		#include "theme_utils.h"
		//Used to get the store path of savubg GetN GUI settings
		void theme_save_as_box_ex1()
		{
			string 	strThemeName = "MyFitSetting";
			string 	strPathName, strDescription, strCategory;
			int 	nthScopeType = THTYPESCOPE_ANALYSIS_CATEGORY;
			if( theme_save_as_box(strPathName, THTYPE_ANALYSIS, strThemeName, strDescription, 
				"FitLinear", nthScopeType, strCategory))
				printf("Path:\n%s\nDescription:\n%s\n", strPathName, strDescription);
		}
		
	Example2:
		//Used to get the store path of saving analysis/statistics report table settings
		void theme_save_as_box_ex2()
		{
			string 	strThemeName = "OutputScripWnd";
			string 	strPathName, strDescription;
			int 	nTableID = 0x08;
			if( theme_save_as_box(strPathName, THTYPE_REPORT_TABLE, strThemeName, strDescription, 
				NULL, NULL, NULL, &nTableID))
				printf("Path:\n%s\nDescription:\n%s\n", strPathName, strDescription);
		}
    Return:
		true if save successfully else false.
              
**/
///Iris 2/21/05 QA70-7416 ADD_THEME_SAVE_AS_BOX
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
//bool    theme_save_as_box(string &strPathName, int thtype, string& strThemeName, string& strDescription,
//LPCSTR lpczClassOption = NULL, int& thScopeType = NULL, string& strCategory = NULL,  int* pnAllTables = NULL, HWND hWndParent = NULL);
bool    theme_save_as_box(string &strPathName, int thtype, string& strThemeName, string& strDescription,
						LPCSTR lpczClassOption = NULL, int& thScopeType = NULL, string& strCategory = NULL,  int* pnAllTables = NULL, HWND hWndParent = NULL, TreeNode& trThemeFilter = NULL
						///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
						, LPCSTR lpcszCustomMakeTree = NULL
						, LPCSTR lpcszCustomName = NULL
						///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
);
///---END THEME_SAVING_OPTIONS

/*
	Load a special theme file into tr.
	Parameters:
		tr = [output] the tree including all informations of theme file
		lpcszName = [input] the theme name
		nPathType = [input] the path type, ORIGIN_PATH_USER etc
		thtype = [input] the theme type, THTYPE_GRAPH etc
		thScope = [input] the scope of analysis, like THTYPESCOPE_ANALYSIS_CLASS etc
		lpczClassOption = [input] Class name and option
		lpcszCategory = [input] Category name
		nTableID = [input] Table ID, used only for THTYPE_REPORT_TABLE
	Return:
		true if save successfully else false.
**/
bool    theme_load(Tree &tr, LPCSTR lpcszName, int nPathType, int thtype, int thScope = THTYPESCOPE_ANALYSES_COMMON, 
LPCSTR lpczClassOption = NULL, LPCSTR lpcszCategory = NULL, uint nTableID = 0);
/*
	Save theme tree to the specail path and filename.
	Parameters:
		tr = [output] the tree including all informations of theme file
		lpcszName = [input] the theme name
		thtype = [input] the theme type, THTYPE_GRAPH etc
		thScope = [input] the scope of analysis, like THTYPESCOPE_ANALYSIS_CLASS etc
		lpczClassOption = [input] Class name and option
		lpcszCategory = [input] Category name
		nTableID = [input] Table ID, used only for THTYPE_REPORT_TABLE
	Return:
		true if save successfully else false.
**/
bool    theme_save(Tree &tr, LPCSTR lpcszName, int thtype, int thScope=THTYPESCOPE_ANALYSES_COMMON, 
LPCSTR lpczClassOption = NULL, LPCSTR lpcszCategory = NULL, uint nTableID = 0);
///End ADD_THEME_SAVE_AS_BOX

/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
bool	is_xf_gui_getn_tree(TreeNode& tr, string* pstrXFname = NULL);
#define	XFGUI_GETN_TAGNAME	"XFGUI"
/// end XF_THEME_SUPPORT
#define	XFGUI_GETN_TAGNAME_NO_THEME	"XFGUINoTheme"	///Jasmine 02/02/07 QA70-9336 FIX_XF_NO_THEME_BUG



string 	theme_get_settings_file(LPCSTR lpcszThemeDisplayName, LPCSTR lpcszClassNameWithOption = NULL, int nThemeType = THTYPE_ANALYSIS, string* pstrThemeName = NULL, int* pnScope=NULL, LPCSTR lpcszCategory=NULL);
bool 	theme_get_next_file_name(string& strFilename, bool bCheckCreatePath=true, int nThemeType = THTYPE_GRAPH);
bool 	theme_rename(string strThemeName, string strOldName, int nPathType, int nThemeType);

///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_apply_and_set_attribute(TreeNode& trGUI, LPCSTR lpcszSelectedThemeName, const string& strClassOption , bool bShowAdvanded, bool bLoadFactDefault=true);
bool theme_apply_and_set_attribute(TreeNode& trGUI, LPCSTR lpcszSelectedThemeName, const string& strClassOption , bool bShowAdvanded, bool bLoadFactDefault=true, TreeNode& trTheme = NULL);
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION

/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
#define STR_SHOW_ADVANCED "ShowAdvanced"
bool 	theme_get_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, DWORD & dwVal);
bool 	theme_get_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, string& strVal);
void 	theme_set_registry_settings(LPCSTR lpcszClassName, LPCSTR lpcszKey, LPCSTR lpcszVal);
///---Sim 03-23-2007 IMPROVE_MULTI_THEME_FRAME_WORK
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr);
/**
		trThemes = [input] this tree node is for multi-themes. when it exist, trGetN will be ignored.
*/
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& trGetN, TreeNode& trThemes = NULL);
/**
		bThemesTree = [input] true if tr is themes tree, not getn tree.
*/
///Cheney 2007-8-1 CORRECT_LOGIC_OF_LOADING_THEME
//void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree = false);
void	theme_update_last_used(LPCSTR lpcszClassName, TreeNode& tr, bool bThemesTree = false, TreeNode& trSrc = NULL, DWORD dwCntrlFromXF = 0);
///end CORRECT_LOGIC_OF_LOADING_THEME
///---END IMPROVE_MULTI_THEME_FRAME_WORK
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool	theme_apply_analysis_theme(LPCSTR lpcszClassName, TreeNode& tr, LPCSTR lpcszThemeName, bool bLoadFactDefault = true); //----- CPY 3/1/07 THEME_AUTOUPDATE_CLEAN_UP change to return bool
bool	theme_apply_analysis_theme(LPCSTR lpcszClassName, TreeNode& tr, LPCSTR lpcszThemeName, bool bLoadFactDefault = true, TreeNode& trTheme = NULL); //----- CPY 3/1/07 THEME_AUTOUPDATE_CLEAN_UP change to return bool
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION

bool	theme_get_recalculate(int& nRecalculate, LPCSTR lpcszClassName, LPCSTR lpcszThemeName, bool bEmptyFileToUseRegSettings = true);
/// end XF_THEME_SUPPORT

/**$
*/				
void theme_update_display_attributes_for_easier_edit(TreeNode& trTheme);
					
/*
	Save theme tree to the specail path and filename.
	Parameters:
		strThemeName = [input] the theme name
		thtype = [input] the theme type, THTYPE_GRAPH etc
		nPathType = [input] theme path type, like THTYPE_SYSTEM etc
		nScope = [input] the scope of analysis, like THTYPESCOPE_ANALYSIS_CLASS etc
		lpcszClassOption = [input] Class name and option
		lpcszCategory = [input] Category name
		pnTableID = [input] Table ID, used only for THTYPE_REPORT_TABLE
	Return:
		true if save successfully else false.
**/
/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
/*					
string okutil_theme_construct_filename(LPCSTR strThemeName, int thtype, int nPathType = ORIGIN_PATH_USER, int nScope=0, 
						LPCSTR lpcszClassOption=NULL, LPCSTR lpcszCategory=NULL, int* pnTableID=NULL);
*/
/// endMOVE_GET_CLASS_SETTINGS_TO_VC
// //string okutil_theme_file_to_display_name(const string& strThemeFile, string* pstrCategory = NULL, int* pnPathType = NULL);
// string okutil_theme_file_to_display_name(LPCSTR lpcszThemeFile, string* pstrCategory = NULL, int* pnPathType = NULL);

/// ML 10/13/2005 QA70-8157 SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS
/**$
*/
BOOL	make_result_curves_sheet_theme(TreeNode &treeTh, DWORD dwResultCurvesReportID);


// dwBorders bits:
enum {
	BORSTY_LEFT			= 0x00000001,
	BORSTY_RIGHT		= 0x00000002,
	BORSTY_TOP			= 0x00000004,
	BORSTY_BOTTOM		= 0x00000008,
	BORSTY_INSIDE_VERT	= 0x00000010,
	BORSTY_INSIDE_HORIZ	= 0x00000020,
};
/**$
*/
void	table_theme_setup_style(TreeNode &trStyle, bool *pbBold = NULL, int bckColor = -1,
				DWORD dwBorders = 0, int nPeriodRowwise = 0, int nPeriodColwise = 0, int nBorderColor = 0, int nMerging = -1, int nBorderWidth = 2);

/// end SPECIAL_NAMES_STYLES_IN_FLAT_SHEETS



///Joe 8/10/06   THEME_ANALYSIS_FILENAME_TO_OPTIONS
bool theme_filename_to_options(LPCSTR lpFileName, string& strName, string& strTool, string& strScope, string& strCategory);
///End THEME_ANALYSIS_FILENAME_TO_OPTIONS

///Joe 8/10/06 THEME_SCOPEINDEX_TO_SCOPENAME
void theme_scopeindex_to_scopename(int nScopeIndex, string& strScopeName);
///End THEME_SCOPEINDEX_TO_SCOPENAME

///Joe 8/11/06 THEME_SCOPENAME_TO_SCOPEINDEX
int theme_scopename_to_scopeindex(LPCSTR strScopeName);
///End THEME_SCOPENAME_TO_SCOPEINDEX

/// SY 2006-10-03 v8.0493 QA70-9015 XF_THEME_BOOK_AND_SHEET
// bLoad = TRUE for getting, FALSE for putting
///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad = FALSE);
///------ Folger 04/29/09 SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
//bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad = FALSE, TreeNode& trTheme = NULL);
bool theme_active_book_sheet_storage(TreeNode& tr, LPCSTR lpcszXFName, int npds, BOOL bLoad = FALSE, TreeNode& trTheme = NULL, OriginObject* pObjSpecified = NULL);
///------ End SUPPORT_GET_BOOK_SHEET_THEME_INFO_FROM_NON_ACTIVE_BOOK_OR_SHEET
///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
/// end XF_THEME_BOOK_AND_SHEET

/// Iris 10/12/06 MOVE_IS_INCREMENT_THEME_INTO_UTILS_FILE
bool theme_is_increment_theme(LPCSTR lpcszThemeFilename);
///end MOVE_IS_INCREMENT_THEME_INTO_UTILS_FILE

///Jasmine 03/27/07 MOVE_TO_TEXTFORMAT	
/////Jasmine 02/26/07 UTILITY_FUNC_FOR_TEXT_FORMAT
///**$
//*/
//bool construct_text_format_tree(TreeNode& tr);
///**$
//*/
//bool get_text_format(const OriginObject& obj, TreeNode& tr, LPCSTR lpcszTagName);
/////End UTILITY_FUNC_FOR_TEXT_FORMAT

///---Sim 03-26-2007 TEMPORARY_FUNCTION_FOR_THEME_UTILS
bool theme_tree_to_getn_tree(const TreeNode& trTheme, TreeNode& trGetN, bool bSupportRunTime = false);
bool theme_tree_from_getn_tree(TreeNode& trTheme, const TreeNode& trGetN, bool bSupportRunTime = false);
bool themes_tree_to_file(Tree& trTheme, LPCSTR lpcszFileName = NULL );
bool themes_tree_from_file(Tree& trTheme, LPCSTR lpcszFileName = NULL );
///---END TEMPORARY_FUNCTION_FOR_THEME_UTILS
///---Sim 11-13-2007 GET_CREATED_OUTPUT_PAGE_INFO
bool get_theme_tree_execution_value(const TreeNode& trTheme, TreeNode& trGetNExecution);
bool set_theme_tree_execution_value(TreeNode& trTheme, const TreeNode& trGetNExecution);
///---END GET_CREATED_OUTPUT_PAGE_INFO

///Folger 05/23/07 XF_IS_THEME_APPLIED
///---Sim 06-30-2007 XF_IS_THEME_APPLIED
enum
{
	THEME_NONE = 0,
	THEME_APPLIED,
	///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
	//THEME_FACTORY_DEFAULT,
	THEME_DEFAULT,
	///---END CLEAN_DEFAULT_THEME
	THEME_SHEET,
	THEME_BOOK,
};

//bool xf_is_theme_applied(const TreeNode &trGetN);
int xf_is_theme_applied(const TreeNode &trGetN);
///---END XF_IS_THEME_APPLIED
///End XF_IS_THEME_APPLIED
///Folger 06/19/07 ADD_INIT_THEME_LIST
bool init_theme_list(TreeNode &trTheme, int nThemeType = THTYPE_GRAPH, bool bTrim = true);
///End ADD_INIT_THEME_LIST

//------ CPY 03/08/08 QA80-11192 REPLACE_FACTORY_DEFAULT_THEME_WITH_DEFAULT
/////---Sim 06-30-2007 PUT_OUT_GLOBAL_FUNC
//bool is_theme_factory_default(LPCSTR lpcszName);
/////---END PUT_OUT_GLOBAL_FUNC
bool is_theme_default(LPCSTR lpcszName);
//------
//------ Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE
///---Sim 11-07-2007 IMPROVE_CHECK_LAST_USED_THEME
//bool is_theme_last_used(LPCSTR lpcszName);
bool is_theme_last_used(LPCSTR lpcszName, bool bSupportFileName = false);
///---END IMPROVE_CHECK_LAST_USED_THEME
//------ End CORRECT_THEME_TYPE_COMPARE

//------ Folger 11/08/07 FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION
int theme_find_predefined_type_index(const vector<string> &vsList, LPCSTR lpcszTypeName);
//------ End FIX_BUGS_WHEN_FIND_THEME_NAME_WITH_LOCALIZATION

//------ Folger 11/12/07 IMPROVE_SAVE_THEME_MECHANISM
enum
{
	THEME_TYPE_SVAE_INVALID = -1,
	THEME_TYPE_SVAE_TO_BOOK,
	THEME_TYPE_SVAE_TO_FILE,
};
int theme_get_save_type(int nThemeType);		//exclude last used theme, which considered invalid
//------ End IMPROVE_SAVE_THEME_MECHANISM

//------ Folger 02/27/08 QA80-11182 WIZARD_THEME_VERSION_MECHANISM
BOOL theme_check_version_show_warning(LPCSTR lpcsz, LPCSTR lpcszRef, LPCSTR lpcszThemeName, LPCSTR lpcszName);
//------ End WIZARD_THEME_VERSION_MECHANISM

//------ Folger 02/29/08 QA80-11192 SHOW_WARNING_WHEN_THEME_NOT_EXIST
void theme_show_warning_not_exist(LPCSTR lpcszTheme);
//------

//------ Folger 03/03/08 QA80-11192 LOAD_DEFAULT_THEME_BEFORE_RESET_TO_FACTORY_DEFAULT
//move to oUtils.h
/*
enum
{
	THEME_DEFAULT_GET,
	THEME_DEFAULT_SET,
	THEME_DEFAULT_RESET,
};
*/
bool	theme_default_setting_management(TreeNode &tr, int nOp = THEME_DEFAULT_GET, TreeNode &trTheme = NULL, bool bGroupTheme = false);
//------

/// Iris 03/04/2008 v8.0816 ACCESS_DEFAULTS_XML
/**$
*/
bool theme_set_default_settings(LPCSTR lpcszClassOption, const TreeNode& trSettings);

/**$
*/
bool theme_get_default_settings(LPCSTR lpcszClassOption, TreeNode& trSettings = NULL);

/**$
*/
bool theme_reset_default_settings(LPCSTR lpcszClassOption);
///end ACCESS_DEFAULTS_XML

//------ Folger 07/02/08 CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME
/*
//------ Folger 03/06/08 QA80-11192 NEW_DEFAULT_THEME_MECHANISM
bool theme_is_factory_default_for_new_mechanism(const string &strTheme);	//<Default> or empty
//------
*/
///---Sim 09-05-2008 CLEAN_DEFAULT_THEME
//bool theme_is_factory_default(const string &strTheme);
bool theme_is_factory_default(LPCSTR lpcszTheme);
///---END CLEAN_DEFAULT_THEME
//------ End CLEAN_UP_FACTORY_DEFAULT_THEME_THAT_SHOULD_BE_REPLACED_BY_EMPTY_THEME

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
BOOL	theme_is_folder_last_used(LPCSTR lpcszTheme);
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
bool theme_setup_theme_filter_setting(TreeNode& trGUI, const TreeNode& trThemeFilter, const vector<int>& vnGUIID, const vector<int>& vnThemeFilterID);
///---END QA80-11371 THEME_SAVING_OPTIONS

//------ Folger 07/11/08 QA80-11787 SUPPORT_THEME_DELETIION_IN_DIALOG_THEME_POPUP_MENU
//void		theme_delete_settings(const TreeNode &tr, HWND hWnd);
//------

///Sophy 10/22/2008 QA80-12422 SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT need to use it in impCSV.OXF, move from impASC.OXF, renamed it from _get_show_options_label
string	get_show_options_label(const TreeNode& trGetN);
///end SUPPORT_SAVE_SHEET_THEME_FOR_EXCEL_CSV_IMPORT

///---Sim 11-14-2008 SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5
bool is_integer_part_less_then(double dVer, double dVerRef);
///---END SUPPORT_PA_THEME_SR4_CONVERT_TO_SR5

///---Sim 12-12-2008 IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE
string theme_get_full_xf_wizard_name(LPCSTR lpcszClassOption);
///---END IMPROVE_XF_WIZARD_FAILED_LOAD_THEME_ERROR_MESSAGE

#define	STR_THEME_NODE_TAGNAME_PREFIX	"node"		///------ Folger 08/07/09 QA80-13998 SUPPORT_GET_GOAL_AND_FITTING_REPORT_GRAPH_UID_FROM_PAWIZMANAGER

///------ Folger 08/25/09 QA80-14145 SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS
BOOL	theme_update_xf_folder_last_used(TreeNode& trGetN, TreeNode& trXF);
BOOL	theme_load_xf_folder_last_used(TreeNode& trGetN, TreeNode& trThemeOut = NULL);
BOOL	theme_remove_xf_folder_last_used(LPCSTR lpcszClassOption);
///------ End SUPPORT_FOLDER_LAST_USED_THEME_IN_PE_XFS

///------ Folger 09/22/09 QA80-14339 RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT
enum
{
	THEMEFORCELOADFACTORY_GET,
	THEMEFORCELOADFACTORY_SET,
	THEMEFORCELOADFACTORY_RESET,
};
BOOL	theme_force_load_factory_attribute_access(TreeNode& tr, int nOption);
///------ End RESET_THEME_SHOULD_LOAD_FACTORY_ONLY_BUT_NOT_DELETE_DEFAULT

///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
#define			STR_THEME_SAVE_AS_CUSTOM_MAKE_TREE_ATTRIB		"ThemeSaveAsCustomMakeTree"
typedef	void (*PFN_THEME_SAVE_AS_CUSTOM_MAKE_TREE) (TreeNode& tr);

#define			STR_THEME_SAVE_AS_CUSTOM_NAME					"ThemeSaveAsCustomName"
typedef	void (*PFN_THEME_SAVE_AS_CUSTOM_NAME) (string& strMoreInfo, TreeNode& tr);
///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI

///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
BOOL		theme_is_valid_name_for_save_as(LPCSTR lpcszName, HWND hWndParentForMsg = NULL);
///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

///------ Folger 04/22/10 QA81-15348 OP_CHANGE_FROM_PA
class WizOperationChangeHelper
{
public:
	BOOL	Convert(TreeNode& tr, BOOL bThemeToGetN);
	
private:
	BOOL	ThemeToGetN(TreeNode& tr, LPCSTR lpcszXFName);	
	BOOL	GetNToTheme(TreeNode& tr);
	
	TreeNode	Wiz(TreeNode& tr);	
	TreeNode	XF(TreeNode& trNode);
	BOOL		IsStep(TreeNode& tr);
	void		CustomGetN(TreeNode& trGetN);
};
///------ End OP_CHANGE_FROM_PA

#endif //_THEMES_H
